@extends('layouts.app')
@section('title','Uplift por Producto')
@section('content')
<div class="container">
  <h5 class="mb-3">Uplift por Producto</h5>
  @if(session('status')) <div class="alert alert-success">{{ session('status') }}</div> @endif

  <form method="get" class="row g-2 mb-3">
    <div class="col-md-6">
      <input type="text" name="q" class="form-control" placeholder="Buscar por nombre o SKU" value="{{ $q }}">
    </div>
    <div class="col-md-2">
      <button class="btn btn-outline-primary">Buscar</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead>
        <tr>
          <th>Producto</th>
          <th>SKU</th>
          <th>Categoría</th>
          <th class="text-end">Base</th>
          <th class="text-end">Uplift (%)</th>
          <th class="text-end">Precio con Uplift</th>
          <th class="text-end">Acciones</th>
        </tr>
      </thead>
      <tbody>
        @foreach($products as $p)
          @php
            $uplift = $uplifts[$p->id] ?? $user->default_uplift_percent ?? 0;
            $priceWith = $p->base_price * (1 + ($uplift/100));
          @endphp
          <tr>
            <td>{{ $p->name }}</td>
            <td>{{ $p->sku }}</td>
            <td>{{ optional($p->category)->name }}</td>
            <td class="text-end">{{ number_format($p->base_price,2) }}</td>
            <td class="text-end">
              <form method="post" action="{{ route('gestor.uplift.products.save',$p) }}" class="d-inline-flex gap-2 justify-content-end">
                @csrf
                <input type="number" step="0.01" min="0" max="1000" name="uplift_percent"
                       value="{{ $uplift }}" class="form-control form-control-sm" style="width:120px">
                <button class="btn btn-sm btn-primary">Guardar</button>
              </form>
            </td>
            <td class="text-end">{{ number_format($priceWith,2) }}</td>
            <td class="text-end">
              @if(isset($uplifts[$p->id]))
                <form method="post" action="{{ route('gestor.uplift.products.delete',$p) }}" onsubmit="return confirm('¿Quitar uplift específico?')">
                  @csrf @method('DELETE')
                  <button class="btn btn-sm btn-outline-danger">Quitar override</button>
                </form>
              @else
                <span class="text-muted small">Usa uplift global</span>
              @endif
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>

  <div class="mt-3">
    {{ $products->links('pagination::bootstrap-5') }}
  </div>
</div>
@endsection
