{{-- resources/views/dashboard.blade.php --}}
<x-admin-layout title="Dashboard">
    {{-- Si quieres, un header nombrado --}}
    <x-slot name="header">
      <h1 class="text-xl font-semibold text-gray-900">Panel general</h1>
      <p class="text-sm text-gray-500">Resumen de actividad y accesos rápidos.</p>
    </x-slot>

    {{-- CONTENIDO PRINCIPAL --}}
    <section>
      {{-- Tarjetas de métricas --}}
      <div class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-4 gap-4">
        <div class="bg-white rounded-xl border border-gray-200 p-4 shadow-sm">
          <div class="text-sm text-gray-500">Productos</div>
          <div class="mt-1 text-2xl font-semibold text-gray-900">{{ $stats['products'] ?? '—' }}</div>
          <div class="mt-2 text-xs text-gray-400">Total en catálogo</div>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 p-4 shadow-sm">
          <div class="text-sm text-gray-500">Categorías</div>
          <div class="mt-1 text-2xl font-semibold text-gray-900">{{ $stats['categories'] ?? '—' }}</div>
          <div class="mt-2 text-xs text-gray-400">Activas</div>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 p-4 shadow-sm">
          <div class="text-sm text-gray-500">Gestores</div>
          <div class="mt-1 text-2xl font-semibold text-gray-900">{{ $stats['gestors'] ?? '—' }}</div>
          <div class="mt-2 text-xs text-gray-400">Con acceso</div>
        </div>

        <div class="bg-white rounded-xl border border-gray-200 p-4 shadow-sm">
          <div class="text-sm text-gray-500">Inventario</div>
          <div class="mt-1 text-2xl font-semibold text-gray-900">
            {{ number_format($stats['stock'] ?? 0) }}
          </div>
          <div class="mt-2 text-xs text-gray-400">Unidades</div>
        </div>
      </div>

      {{-- Tabla rápida / últimos productos --}}
      <div class="mt-6 bg-white rounded-xl border border-gray-200 shadow-sm overflow-hidden">
        <div class="px-4 py-3 border-b border-gray-100 flex items-center justify-between">
          <div class="text-sm font-semibold text-gray-900">Últimos productos</div>
          <a class="text-sm font-medium text-blue-600 hover:text-blue-700"
             href="{{ route('zapatera.admin.products.index') }}">Ver todos</a>
        </div>

        <div class="overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead class="bg-gray-50 text-gray-600">
              <tr>
                <th class="px-4 py-2 text-left font-medium">Producto</th>
                <th class="px-4 py-2 text-left font-medium">SKU</th>
                <th class="px-4 py-2 text-left font-medium">Categoría</th>
                <th class="px-4 py-2 text-right font-medium">Precio base</th>
                <th class="px-4 py-2 text-right font-medium">Acciones</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
              @forelse(($latestProducts ?? []) as $p)
                <tr>
                  <td class="px-4 py-2 text-gray-900">{{ $p->name }}</td>
                  <td class="px-4 py-2 text-gray-600">{{ $p->sku }}</td>
                  <td class="px-4 py-2 text-gray-600">{{ optional($p->category)->name ?: '—' }}</td>
                  <td class="px-4 py-2 text-right text-gray-900">
                    {{ number_format($p->base_price, 2) }}
                  </td>
                  <td class="px-4 py-2 text-right">
                    <a href="{{ route('zapatera.admin.products.edit',$p) }}"
                       class="inline-flex items-center px-3 py-1.5 rounded-lg text-xs font-semibold
                              bg-blue-50 text-blue-700 hover:bg-blue-100">Editar</a>
                  </td>
                </tr>
              @empty
                <tr>
                  <td colspan="5" class="px-4 py-10 text-center text-gray-400">
                    No hay productos recientes.
                  </td>
                </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </section>
  </x-admin-layout>
