@props([
  'title',
  'sku'=>null,
  'price'=>null,
  'image'=>null,
  'stock'=>null,
  'url'=>null,
  'galleryUrl' => null,
])

<article class="nlx-card h-full flex flex-col">
  @if($image)
    <img src="{{ $image }}" alt="{{ $title }}" class="w-full h-48 object-cover">
  @endif

  <div class="nlx-card-body flex-1 flex flex-col gap-2">
    <h6 class="font-semibold text-gray-900">{{ $title }}</h6>
    @if($sku || !is_null($stock))
      <div class="text-sm text-gray-500">
        @if($sku) SKU {{ $sku }} @endif
        @if(!is_null($stock)) · Stock {{ $stock }} @endif
      </div>
    @endif
    @if(!is_null($price))
      <div class="nlx-price">{{ $price }}</div>
    @endif
    <div class="mt-2">
      <a href="{{ $url ?? '#' }}" class="nlx-btn-accent w-full text-center">Pedir por WhatsApp</a>
    </div>
  </div>
</article>
