@php
  /** @var \Illuminate\Support\Collection $items */
  /** @var string $primaryCode */
  /** @var bool $showBoth */
  /** @var string $variant */
  $others = $items->filter(fn($i) => !$i['is_primary']);
@endphp

@if($items->isNotEmpty())
  <div class="w-full rounded-2xl border bg-white px-3 py-2 text-sm text-slate-700">
    @if($variant === 'stacked')
      {{-- ====== VARIANTE APILADA (ideal sidebar) ====== --}}
      <div class="flex flex-col gap-2">
        <div class="inline-flex items-center gap-2">
          <span class="inline-flex items-center gap-1 rounded-full bg-slate-900 px-3 py-1 text-white">
            <span class="font-semibold">{{ $primaryCode }}</span>
            <span class="text-xs opacity-80">base</span>
          </span>
          <span class="text-slate-400">•</span>
        </div>

        @foreach($others as $it)
          <div class="rounded-xl bg-slate-100 px-3 py-2">
            <div class="flex flex-col gap-1">
              <div class="flex items-center gap-2">
                <span class="inline-flex items-center gap-1 rounded-full bg-white px-2 py-0.5 text-xs border">
                  <span class="font-semibold">{{ $it['code'] }}</span>
                </span>
                {{-- Línea 1: 1 BASE = N OTRA --}}
                <span class="inline-flex items-center gap-1 rounded-full bg-slate-200/70 px-2 py-0.5 text-[11px]">
                  <span>1 {{ $primaryCode }}</span>
                  <span>=</span>
                  <span class="font-mono">{{ number_format($it['eq_per_primary'], $decimals) }}</span>
                  <span>{{ $it['code'] }}</span>
                </span>
              </div>

              @if($showBoth)
                {{-- Línea 2: 1 OTRA = rate BASE --}}
                <div class="inline-flex items-center gap-1 rounded-full bg-slate-200/70 px-2 py-0.5 text-[11px]">
                  <span>1 {{ $it['code'] }}</span>
                  <span>=</span>
                  <span class="font-mono">{{ number_format($it['rate_to_primary'], $decimals) }}</span>
                  <span>{{ $primaryCode }}</span>
                </div>
              @endif
            </div>
          </div>
        @endforeach
      </div>
    @else
      {{-- ====== VARIANTE SCROLL (chips en fila) ====== --}}
      <div class="flex gap-2 items-center whitespace-nowrap overflow-x-auto overscroll-x-contain snap-x scroll-px-2 pr-2">
        <span class="shrink-0 snap-start inline-flex items-center gap-1 rounded-full bg-slate-900 px-3 py-1 text-white">
          <span class="font-semibold">{{ $primaryCode }}</span>
          <span class="text-xs opacity-80">base</span>
        </span>
        <span class="text-slate-400 shrink-0">•</span>

        @foreach($others as $it)
          <span class="shrink-0 snap-start inline-flex items-center gap-2 rounded-full bg-slate-100 px-3 py-1">
            <span class="inline-flex items-center gap-1 rounded-full bg-white px-2 py-0.5 text-xs border">
              <span class="font-semibold">{{ $it['code'] }}</span>
            </span>

            <span class="inline-flex items-center gap-1 rounded-full bg-slate-200/70 px-2 py-0.5 text-xs">
              <span>1 {{ $primaryCode }}</span>
              <span>=</span>
              <span class="font-mono">{{ number_format($it['eq_per_primary'], $decimals) }}</span>
              <span>{{ $it['code'] }}</span>
            </span>

            @if($showBoth)
              <span class="inline-flex items-center gap-1 rounded-full bg-slate-200/70 px-2 py-0.5 text-xs">
                <span>1 {{ $it['code'] }}</span>
                <span>=</span>
                <span class="font-mono">{{ number_format($it['rate_to_primary'], $decimals) }}</span>
                <span>{{ $primaryCode }}</span>
              </span>
            @endif
          </span>
        @endforeach
      </div>
    @endif
  </div>
@endif
