{{-- Componente: layout base del sitio --}}
@props(['title' => config('app.name', 'GuineraStore')])

<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{ $title }}</title>

  {{-- CSS/JS --}}
  @vite(['resources/css/app.css','resources/js/app.js'])
  @stack('head')
</head>
<body class="bg-slate-50 text-slate-800">
  {{-- Navbar global, si tienes uno --}}
  @includeIf('layouts.partials.nav')

  {{-- Contenido de la página --}}
  <main>
    {{ $slot }}
  </main>

  {{-- Footer global, si lo tienes --}}
  @includeIf('layouts.partials.footer')

  @stack('scripts')
</body>
</html>
