{{-- resources/views/components/admin-layout.blade.php --}}
@props(['title' => 'Panel'])

<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{ $title }}</title>

  @vite('resources/css/app.css')
  @vite('resources/js/app.js')

  @env('production')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.css">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js" defer></script>
  @endenv

  <link rel="icon" type="image/png" sizes="512x512" href="{{ asset('img/favicon-512.png') }}">
  <link rel="icon" type="image/png" sizes="192x192" href="{{ asset('img/favicon-192.png') }}">
  <link rel="apple-touch-icon" href="{{ asset('img/apple-touch-icon.png') }}">
  <link rel="shortcut icon" href="{{ asset('img/favicon.ico') }}">

  <style>
    :root{ --admin-header-pl:0 }
    [x-cloak]{display:none!important}
    /* Acerca el contenido del header al borde izq en admin */
    body[data-admin="1"] header{ padding-left:2rem!important }
    body[data-admin="1"] header .container,
    body[data-admin="1"] header .mx-auto,
    body[data-admin="1"] header .max-w-7xl{ margin-left:0!important; padding-left:0!important }
    body[data-admin="1"] header [class*="px-"],
    body[data-admin="1"] header [class*="pl-"],
    body[data-admin="1"] header [class*="sm:px-"],
    body[data-admin="1"] header [class*="lg:px-"]{ padding-left:0!important }
    body[data-admin="1"] header [class*="ml-"]{ margin-left:0!important }
  </style>
</head>
<body class="bg-slate-50 text-slate-800" data-admin="1">
  {{-- Header (tu partial ya es sticky top-0) --}}
  @include('partials.admin.header')

  {{-- ===== Shell: header fijo + sidebar (drawer en móvil) ===== --}}
  <div
    x-data="sidebarDrawer()"
    x-init="init()"
    x-effect="lockScroll(open)"
    @sidebar:toggle.window="open = !open"
    class="min-h-[calc(100vh-56px)] lg:grid lg:grid-cols-[18rem_minmax(0,1fr)]"
  >

    {{-- === Backdrop móvil (tocar fuera para cerrar) === --}}
    <div
      x-cloak
      x-show="open"
      x-transition.opacity
      class="fixed inset-0 z-40 bg-black/40 lg:hidden"
      @click="close()"
      aria-hidden="true">
    </div>

    {{-- === Sidebar: drawer en móvil (fixed), sticky en desktop === --}}
    <aside
      x-cloak
      @keydown.escape.window="close()"
      class="
        bg-white border-r border-slate-200
        fixed inset-y-0 left-0 z-50 w-72 transform transition-transform duration-200
        -translate-x-full lg:translate-x-0
        lg:sticky lg:top-14 lg:h-[calc(100vh-56px)] lg:z-0
      "
      :class="{'translate-x-0': open}"
    >
      {{-- Cerrar (solo visible en móvil) --}}
      <button
        class="lg:hidden absolute right-2 top-2 inline-flex h-8 w-8 items-center justify-center rounded-full bg-gray-100 text-gray-700 hover:bg-gray-200"
        @click="close()" aria-label="Cerrar">✕</button>

      {{-- Separación bajo el header solo en mobile (porque es fixed) --}}
      <div class="h-14 lg:hidden"></div>

      {{-- Scroll interno del sidebar --}}
      <div class="h-full overflow-y-auto px-4 py-4">
        <div class="mb-3 text-xs font-semibold text-slate-400">Navegación</div>

        {{-- Al hacer click en cualquier link del menú en móvil, cerramos el drawer --}}
        <nav @click.capture="maybeCloseOnLink($event)">
          @include('partials.admin.sidebar')
        </nav>
      </div>
    </aside>

    {{-- === Contenido principal (scrollea independientemente) === --}}
    <main class="px-4 sm:px-6 lg:px-8 py-6 lg:min-h-[calc(100vh-56px)]">
        @if (session('status'))
            <div class="mb-4 rounded-lg border border-green-200 bg-green-50 px-4 py-2 text-green-800">
                {{ session('status') }}
            </div>
        @endif

        @isset($header)
            <header class="mb-6">
            {{ $header }}
            </header>
        @endisset

        {{ $slot }}
    </main>
  </div>

  @stack('styles')

  @push('scripts')
  <script>
    function sidebarDrawer() {
      return {
        open: false,
        init() {
          // Soporta el evento global que ya usas desde el header
          window.addEventListener('sidebar:toggle', () => {
            this.open = !this.open;
          });
        },
        close() { this.open = false; },
        lockScroll(isOpen) {
          document.body.classList.toggle('overflow-hidden', !!isOpen);
        },
        // Cierra si se hace click en un <a> (solo tiene efecto en móvil)
        maybeCloseOnLink(e) {
          if (window.matchMedia('(min-width: 1024px)').matches) return; // lg+
          const a = e.target.closest('a[href]');
          if (a && !a.target && !e.metaKey && !e.ctrlKey && !e.shiftKey && e.button !== 1) {
            // Espera al inicio de navegación para que se vea el feedback del click
            requestAnimationFrame(() => this.close());
          }
        }
      }
    }
  </script>
  @endpush

  @stack('scripts')
</body>
</html>
