{{-- resources/views/components/admin-layout.blade.php --}}
@props(['title' => 'Panel'])

<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{ $title }}</title>

  @vite('resources/css/app.css')
  @vite('resources/js/app.js')

  @env('production')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/css/tom-select.css">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.3.1/dist/js/tom-select.complete.min.js" defer></script>
  @endenv

  <link rel="icon" type="image/png" sizes="512x512" href="{{ asset('img/favicon-512.png') }}">
  <link rel="icon" type="image/png" sizes="192x192" href="{{ asset('img/favicon-192.png') }}">
  <link rel="apple-touch-icon" href="{{ asset('img/apple-touch-icon.png') }}">
  <link rel="shortcut icon" href="{{ asset('img/favicon.ico') }}">

  <style>
    :root{ --admin-header-pl:0 }
    [x-cloak]{display:none!important}
    /* Acerca el contenido del header al borde izq en admin */
    body[data-admin="1"] header{ padding-left:2rem!important }
    body[data-admin="1"] header .container,
    body[data-admin="1"] header .mx-auto,
    body[data-admin="1"] header .max-w-7xl{ margin-left:0!important; padding-left:0!important }
    body[data-admin="1"] header [class*="px-"],
    body[data-admin="1"] header [class*="pl-"],
    body[data-admin="1"] header [class*="sm:px-"],
    body[data-admin="1"] header [class*="lg:px-"]{ padding-left:0!important }
    body[data-admin="1"] header [class*="ml-"]{ margin-left:0!important }
  </style>
</head>
<body class="bg-slate-50 text-slate-800" data-admin="1">
  {{-- Header (tu partial ya es sticky top-0) --}}
  @include('partials.admin.header')

  {{-- Shell: header fijo + sidebar fijo en desktop --}}
  <div class="min-h-[calc(100vh-56px)] lg:grid lg:grid-cols-[18rem_minmax(0,1fr)]">

    {{-- Sidebar: drawer en mobile (fixed), sticky en desktop debajo del header --}}
    <aside x-data="{open:false}"
           @sidebar:toggle.window="open=!open"
           class="
             bg-white border-r border-slate-200
             fixed inset-y-0 left-0 z-40 w-72 -translate-x-full transform transition-transform duration-200
             lg:translate-x-0 lg:w-[18rem]
             lg:sticky lg:top-14 lg:h-[calc(100vh-56px)]
           "
           :class="{'translate-x-0': open}">
      {{-- Separación bajo el header solo en mobile (porque es fixed) --}}
      <div class="h-14 lg:hidden"></div>

      {{-- Scroll interno del sidebar (en desktop la altura queda fijada por h-[calc...]) --}}
      <div class="h-full overflow-y-auto px-4 py-4">
        <div class="mb-3 text-xs font-semibold text-slate-400">Navegación</div>
        @include('partials.admin.sidebar')
      </div>
    </aside>

    {{-- Contenido principal (scrollea independientemente del sidebar) --}}
    <main class="px-4 sm:px-6 lg:px-8 py-6 lg:min-h-[calc(100vh-56px)]">
      @isset($header)
        <header class="mb-6">
          {{ $header }}
        </header>
      @endisset

      {{ $slot }}
    </main>
  </div>

  @stack('styles')
  @stack('scripts')
</body>
</html>
