{{-- resources/views/components/admin-layout.blade.php --}}
@props([
  'title' => 'Panel',   // título de <title>
])

<x-app-layout :title="$title">
  <div class="mx-auto max-w-[1400px] px-4 py-6">
    <div class="grid grid-cols-12 gap-6">
      {{-- Sidebar izquierda fija --}}
      <aside class="col-span-12 md:col-span-3">
        {{-- Usa tu menú existente --}}
        @include('partials.admin.sidebar')
      </aside>

      {{-- Contenido principal --}}
      <main class="col-span-12 md:col-span-9">
        {{-- Slot opcional para un header de página --}}
        @isset($header)
          <div class="mb-4">
            {{ $header }}
          </div>
        @endisset

        {{ $slot }}
      </main>
    </div>
  </div>
</x-app-layout>
