@php($email = request('email') ?? old('email'))
<x-guest-layout>
  <div class="min-h-[80vh] grid place-items-center px-4">
    <div class="w-full max-w-md">
      <div class="text-center mb-6">
        <img src="{{ asset('img/logo.png') }}" alt="Logo" class="mx-auto h-12 w-12 rounded">
        <h1 class="mt-3 text-xl font-semibold text-slate-900">Restablecer contraseña</h1>
        <p class="text-sm text-slate-500">Ingresa y confirma tu nueva contraseña</p>
      </div>

      <div class="rounded-2xl bg-white shadow-card ring-1 ring-slate-200 p-5 sm:p-6">
        <form method="POST" action="{{ route('password.update') }}" novalidate>
          @csrf
          <input type="hidden" name="token" value="{{ request()->route('token') }}">

          {{-- Email (readonly para evitar errores de token) --}}
          <label for="email" class="block text-sm font-medium text-slate-700">Email</label>
          <input id="email" type="email" name="email" value="{{ $email }}" required readonly
                 class="mt-1 block w-full rounded-lg border-slate-300 bg-slate-50 px-3 py-2
                        focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('email') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror" />
          <x-input-error :messages="$errors->get('email')" class="mt-2" />

          {{-- Password --}}
          <label for="password" class="block text-sm font-medium text-slate-700 mt-4">Nueva contraseña</label>
          <div class="mt-1 relative">
            <input id="password" name="password" type="password" required
                   class="block w-full rounded-lg border-slate-300 pl-3 pr-10 py-2
                          focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('password') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                   placeholder="••••••••" />
            <button type="button" id="togglePwdReset1"
                    class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                    aria-label="Mostrar u ocultar contraseña">
              <svg id="eyeOpenReset1" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/></svg>
              <svg id="eyeClosedReset1" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M3 3l18 18"/><path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/><path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/><path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/></svg>
            </button>
          </div>
          <x-input-error :messages="$errors->get('password')" class="mt-2" />

          {{-- Confirmación --}}
          <label for="password_confirmation" class="block text-sm font-medium text-slate-700 mt-4">Confirmar contraseña</label>
          <div class="mt-1 relative">
            <input id="password_confirmation" name="password_confirmation" type="password" required
                   class="block w-full rounded-lg border-slate-300 pl-3 pr-10 py-2
                          focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500"
                   placeholder="••••••••" />
            <button type="button" id="togglePwdReset2"
                    class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                    aria-label="Mostrar u ocultar confirmación">
              <svg id="eyeOpenReset2" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/></svg>
              <svg id="eyeClosedReset2" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M3 3l18 18"/><path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/><path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/><path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/></svg>
            </button>
          </div>

          <div class="mt-5">
            <button class="inline-flex w-full items-center justify-center gap-2 rounded-lg bg-indigo-600 px-4 py-2.5 text-white font-medium hover:bg-indigo-700 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-indigo-500">
              Guardar nueva contraseña
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script>
    const toggles = [
      ['togglePwdReset1','password','eyeOpenReset1','eyeClosedReset1'],
      ['togglePwdReset2','password_confirmation','eyeOpenReset2','eyeClosedReset2']
    ];
    document.addEventListener('DOMContentLoaded', () => {
      toggles.forEach(([btnId, inputId, oId, cId]) => {
        const btn = document.getElementById(btnId);
        const inp = document.getElementById(inputId);
        const o = document.getElementById(oId);
        const c = document.getElementById(cId);
        if (!btn || !inp) return;
        btn.addEventListener('click', () => {
          const show = inp.type === 'text';
          inp.type = show ? 'password' : 'text';
          o?.classList.toggle('hidden', !show);
          c?.classList.toggle('hidden', show);
        });
      });
    });
  </script>
</x-guest-layout>
