<x-guest-layout>
    <div class="min-h-[80vh] grid place-items-center px-4">
      <div class="w-full max-w-md">
        <div class="text-center mb-6">
          <img src="{{ asset('img/ferguti-logo.png') }}" alt="Logo" class="mx-auto h-12 w-12 rounded">
          <h1 class="mt-3 text-xl font-semibold text-slate-900">Crear cuenta</h1>
          <p class="text-sm text-slate-500">Regístrate para acceder al panel</p>
        </div>

        <div class="rounded-2xl bg-white shadow-card ring-1 ring-slate-200 p-5 sm:p-6">
          <form method="POST" action="{{ route('register') }}" novalidate>
            @csrf

            {{-- Nombre --}}
            <label for="name" class="block text-sm font-medium text-slate-700">Nombre</label>
            <input id="name" name="name" type="text" value="{{ old('name') }}" required autofocus
                   class="mt-1 block w-full rounded-lg border-slate-300 px-3 py-2
                          focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('name') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                   placeholder="Tu nombre" />
            <x-input-error :messages="$errors->get('name')" class="mt-2" />

            {{-- Email --}}
            <label for="email" class="block text-sm font-medium text-slate-700 mt-4">Email</label>
            <input id="email" name="email" type="email" value="{{ old('email') }}" required
                   class="mt-1 block w-full rounded-lg border-slate-300 px-3 py-2
                          focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('email') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                   placeholder="tucorreo@ejemplo.com" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />

            {{-- Password --}}
            <label for="password" class="block text-sm font-medium text-slate-700 mt-4">Password</label>
            <div class="mt-1 relative">
              <input id="password" name="password" type="password" required
                     class="block w-full rounded-lg border-slate-300 pl-3 pr-10 py-2
                            focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('password') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                     placeholder="••••••••" />
              <button type="button" id="togglePwdReg1"
                      class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                      aria-label="Mostrar u ocultar contraseña">
                <svg id="eyeOpenReg1" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/></svg>
                <svg id="eyeClosedReg1" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M3 3l18 18"/><path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/><path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/><path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/></svg>
              </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />

            {{-- Confirmación --}}
            <label for="password_confirmation" class="block text-sm font-medium text-slate-700 mt-4">Confirmar password</label>
            <div class="mt-1 relative">
              <input id="password_confirmation" name="password_confirmation" type="password" required
                     class="block w-full rounded-lg border-slate-300 pl-3 pr-10 py-2
                            focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500"
                     placeholder="••••••••" />
              <button type="button" id="togglePwdReg2"
                      class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                      aria-label="Mostrar u ocultar confirmación">
                <svg id="eyeOpenReg2" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/></svg>
                <svg id="eyeClosedReg2" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8"><path d="M3 3l18 18"/><path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/><path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/><path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/></svg>
              </button>
            </div>

            {{-- Acciones --}}
            <div class="mt-5 space-y-3">
              <button class="inline-flex w-full items-center justify-center gap-2 rounded-lg bg-indigo-600 px-4 py-2.5 text-white font-medium hover:bg-indigo-700 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-indigo-500">
                Crear cuenta
              </button>
              <div class="text-center text-sm text-slate-600">
                ¿Ya tienes cuenta?
                <a href="{{ route('login') }}" class="text-indigo-600 hover:text-indigo-700 font-medium">Inicia sesión</a>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

    <script>
      const toggles = [
        ['togglePwdReg1','password','eyeOpenReg1','eyeClosedReg1'],
        ['togglePwdReg2','password_confirmation','eyeOpenReg2','eyeClosedReg2']
      ];
      document.addEventListener('DOMContentLoaded', () => {
        toggles.forEach(([btnId, inputId, oId, cId]) => {
          const btn = document.getElementById(btnId);
          const inp = document.getElementById(inputId);
          const o = document.getElementById(oId);
          const c = document.getElementById(cId);
          if (!btn || !inp) return;
          btn.addEventListener('click', () => {
            const show = inp.type === 'text';
            inp.type = show ? 'password' : 'text';
            o?.classList.toggle('hidden', !show);
            c?.classList.toggle('hidden', show);
          });
        });
      });
    </script>
  </x-guest-layout>
