{{-- resources/views/auth/login.blade.php --}}
<x-guest-layout>
    {{-- Contenedor de la página --}}
    <div class="min-h-[80vh] grid place-items-center px-4">
      <div class="w-full max-w-md">
        {{-- Marca --}}
        <div class="text-center mb-6">
          <img src="{{ asset('img/ferguti-logo.png') }}" alt="Logo" class="mx-auto h-12 w-12 rounded">
          <h1 class="mt-3 text-xl font-semibold text-slate-900">Iniciar sesión</h1>
          <p class="text-sm text-slate-500">Accede al panel de administración</p>
        </div>

        {{-- Card --}}
        <div class="rounded-2xl bg-white shadow-card ring-1 ring-slate-200 p-5 sm:p-6">

          {{-- Status (ej. link enviado) --}}
          <x-auth-session-status class="mb-4" :status="session('status')" />

          <form method="POST" action="{{ route('login') }}" novalidate>
            @csrf

            {{-- Email --}}
            <label for="email" class="block text-sm font-medium text-slate-700">Email</label>
            <div class="mt-1 relative">
              <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400">
                {{-- icono mail --}}
                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M3 7l9 6 9-6" />
                  <rect x="3" y="5" width="18" height="14" rx="2" />
                </svg>
              </span>
              <input
                id="email"
                type="email"
                name="email"
                value="{{ old('email') }}"
                required
                autofocus
                autocomplete="username"
                class="block w-full rounded-lg border-slate-300 pl-10 pr-3 py-2 text-slate-900 placeholder-slate-400
                       focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('email') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                placeholder="tucorreo@ejemplo.com"
              />
            </div>
            <x-input-error :messages="$errors->get('email')" class="mt-2" />

            {{-- Password --}}
            <label for="password" class="block text-sm font-medium text-slate-700 mt-4">Password</label>
            <div class="mt-1 relative">
              <span class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400">
                {{-- icono candado --}}
                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M7 10V7a5 5 0 0 1 10 0v3"/>
                  <rect x="5" y="10" width="14" height="10" rx="2"/>
                </svg>
              </span>
              <input
                id="password"
                type="password"
                name="password"
                required
                autocomplete="current-password"
                class="block w-full rounded-lg border-slate-300 pl-10 pr-10 py-2 text-slate-900 placeholder-slate-400
                       focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('password') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                placeholder="••••••••"
              />
              {{-- toggle ver/ocultar --}}
              <button type="button" id="togglePwd"
                class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                aria-label="Mostrar u ocultar contraseña">
                <svg id="eyeOpen" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/>
                  <circle cx="12" cy="12" r="3"/>
                </svg>
                <svg id="eyeClosed" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M3 3l18 18"/>
                  <path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/>
                  <path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/>
                  <path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/>
                </svg>
              </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />

            {{-- Remember + Forgot --}}
            <div class="mt-4 flex items-center justify-between">
              <label for="remember_me" class="inline-flex items-center gap-2 text-sm text-slate-700">
                <input id="remember_me" type="checkbox"
                       class="rounded border-slate-300 text-indigo-600 focus:ring-indigo-500"
                       name="remember">
                <span>Recordarme</span>
              </label>

              @if (Route::has('password.request'))
                <a href="{{ route('password.request') }}"
                   class="text-sm text-indigo-600 hover:text-indigo-700">
                  ¿Olvidaste tu contraseña?
                </a>
              @endif
            </div>

            {{-- Submit --}}
            <div class="mt-5">
              <button
                class="inline-flex w-full items-center justify-center gap-2 rounded-lg bg-indigo-600 px-4 py-2.5
                       text-white font-medium hover:bg-indigo-700 focus-visible:outline-none
                       focus-visible:ring-2 focus-visible:ring-indigo-500">
                Iniciar sesión
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>

    {{-- Toggle password (mínimo y vanilla) --}}
    <script>
      document.addEventListener('DOMContentLoaded', () => {
        const input = document.getElementById('password');
        const btn   = document.getElementById('togglePwd');
        const open  = document.getElementById('eyeOpen');
        const close = document.getElementById('eyeClosed');
        if (!input || !btn) return;
        btn.addEventListener('click', () => {
          const showing = input.type === 'text';
          input.type = showing ? 'password' : 'text';
          open.classList.toggle('hidden', !showing);
          close.classList.toggle('hidden', showing);
        });
      });
    </script>
  </x-guest-layout>
