<x-guest-layout>
    <div class="min-h-[80vh] grid place-items-center px-4">
      <div class="w-full max-w-md">
        <div class="text-center mb-6">
          <img src="{{ asset('img/ferguti-logo.png') }}" alt="Logo" class="mx-auto h-12 w-12 rounded">
          <h1 class="mt-3 text-xl font-semibold text-slate-900">¿Olvidaste tu contraseña?</h1>
          <p class="text-sm text-slate-500">Te enviaremos un enlace para restablecerla</p>
        </div>

        <div class="rounded-2xl bg-white shadow-card ring-1 ring-slate-200 p-5 sm:p-6">
          <x-auth-session-status class="mb-4" :status="session('status')" />

          <form method="POST" action="{{ route('password.email') }}" novalidate>
            @csrf

            <label for="email" class="block text-sm font-medium text-slate-700">Email</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus
                   class="mt-1 block w-full rounded-lg border-slate-300 px-3 py-2
                          focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('email') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                   placeholder="tucorreo@ejemplo.com" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />

            <div class="mt-5">
              <button class="inline-flex w-full items-center justify-center gap-2 rounded-lg bg-indigo-600 px-4 py-2.5 text-white font-medium hover:bg-indigo-700 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-indigo-500">
                Enviarme el enlace
              </button>
            </div>

            <div class="mt-4 text-center text-sm">
              <a href="{{ route('login') }}" class="text-slate-600 hover:text-slate-800">Volver al inicio de sesión</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </x-guest-layout>
