<x-guest-layout>
    <div class="min-h-[80vh] grid place-items-center px-4">
      <div class="w-full max-w-md">
        <div class="text-center mb-6">
          <img src="{{ asset('img/ferguti-logo.png') }}" alt="Logo" class="mx-auto h-12 w-12 rounded">
          <h1 class="mt-3 text-xl font-semibold text-slate-900">Confirmar contraseña</h1>
          <p class="text-sm text-slate-500">
            Por seguridad, confirma tu contraseña para continuar.
          </p>
        </div>

        <div class="rounded-2xl bg-white shadow-card ring-1 ring-slate-200 p-5 sm:p-6">
          <form method="POST" action="{{ route('password.confirm') }}" novalidate>
            @csrf

            {{-- Password --}}
            <label for="password" class="block text-sm font-medium text-slate-700">Contraseña</label>
            <div class="mt-1 relative">
              <input
                id="password"
                name="password"
                type="password"
                required
                autocomplete="current-password"
                class="block w-full rounded-lg border-slate-300 pl-3 pr-10 py-2
                       focus:border-indigo-500 focus:ring-2 focus:ring-indigo-500 @error('password') border-rose-300 focus:border-rose-400 focus:ring-rose-200 @enderror"
                placeholder="••••••••"
              />
              <button type="button" id="togglePwdConfirm"
                      class="absolute inset-y-0 right-0 pr-3 flex items-center text-slate-400 hover:text-slate-600"
                      aria-label="Mostrar u ocultar contraseña">
                <svg id="eyeOpenConfirm" class="h-5 w-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M2 12s3.5-7 10-7 10 7 10 7-3.5 7-10 7-10-7-10-7Z"/><circle cx="12" cy="12" r="3"/>
                </svg>
                <svg id="eyeClosedConfirm" class="h-5 w-5 hidden" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8">
                  <path d="M3 3l18 18"/><path d="M10.6 10.6a3 3 0 0 0 4.24 4.24"/>
                  <path d="M9.88 5.11A9.93 9.93 0 0 1 12 5c6.5 0 10 7 10 7a18.7 18.7 0 0 1-3.06 3.94"/>
                  <path d="M6.24 6.24A18.8 18.8 0 0 0 2 12s3.5 7 10 7a9.8 9.8 0 0 0 3.4-.58"/>
                </svg>
              </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />

            <div class="mt-5 flex items-center justify-between gap-3">
              <a href="{{ url()->previous() }}"
                 class="inline-flex items-center justify-center rounded-lg border border-slate-200 px-4 py-2 text-slate-700 hover:bg-slate-50">
                Cancelar
              </a>
              <button
                class="inline-flex items-center justify-center rounded-lg bg-indigo-600 px-4 py-2.5 text-white font-medium hover:bg-indigo-700 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-indigo-500">
                Confirmar
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <script>
      document.addEventListener('DOMContentLoaded', () => {
        const btn = document.getElementById('togglePwdConfirm');
        const inp = document.getElementById('password');
        const eyeO = document.getElementById('eyeOpenConfirm');
        const eyeC = document.getElementById('eyeClosedConfirm');
        if (!btn || !inp) return;
        btn.addEventListener('click', () => {
          const isText = inp.type === 'text';
          inp.type = isText ? 'password' : 'text';
          eyeO?.classList.toggle('hidden', !isText);
          eyeC?.classList.toggle('hidden', isText);
        });
      });
    </script>
  </x-guest-layout>
