{{-- resources/views/admin/settings/edit.blade.php --}}
@extends('layouts.admin')

@section('content')
<h1 class="text-xl font-semibold mb-3">Configuración</h1>

@if(session('status'))
  <div class="mb-3 rounded-lg bg-emerald-50 text-emerald-700 px-3 py-2">{{ session('status') }}</div>
@endif

<form method="POST" action="{{ route('zapatera.admin.settings.update') }}" class="space-y-6">
  @csrf
  @method('PUT')

  <section class="rounded-lg border p-4">
    <h2 class="text-base font-semibold mb-2">Inventario — Totales</h2>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
      <div>
        <label class="block text-sm font-medium text-gray-700 mb-1">Tipo de render</label>
        <select name="inventory.totals.render_type" class="w-full rounded-lg border-gray-300">
          <option value="simple"  @selected($renderType==='simple')>Simple</option>
          <option value="complex" @selected($renderType==='complex')>Complex</option>
        </select>
        @error('inventory.totals.render_type')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700 mb-1">Raw (sin decimales)</label>
        <select name="inventory.totals.raw" class="w-full rounded-lg border-gray-300">
          <option value="0" @selected(!$raw)>false</option>
          <option value="1" @selected($raw)>true</option>
        </select>
        @error('inventory.totals.raw')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-700 mb-1">Sólo con stock</label>
        <select name="inventory.totals.only_with_stock" class="w-full rounded-lg border-gray-300">
          <option value="0" @selected(!$onlyWithStock)>false</option>
          <option value="1" @selected($onlyWithStock)>true</option>
        </select>
        @error('inventory.totals.only_with_stock')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
      </div>
    </div>
  </section>

  <div>
    <button class="rounded-lg bg-indigo-600 text-white px-4 py-2">Guardar</button>
  </div>
</form>
@endsection
