import './bootstrap';

import Alpine from 'alpinejs';

window.Alpine = Alpine;

Alpine.start();

if (!window.TomSelect && !import.meta.env.PROD) {
    import('tom-select').then(m => { window.TomSelect = m.default; }).catch(() => {});
  }

  window.initTomSelect = (el, opts = {}) => {
    if (!el || el.tomselect || !window.TomSelect) return null;
    return new window.TomSelect(el, {
      create: false,
      allowEmptyOption: true,
      searchField: ['text'],
      maxOptions: 5000,
      plugins: ['dropdown_input','clear_button'],
      ...opts,
    });
  };

