<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use App\Models\{Category, Product, ProductVariant, VariantStock, Media, Gestor};

class ZapateraSeeder extends Seeder
{
    public function run(): void
    {
        $low = Category::firstOrCreate(['slug'=>'precio-bajo'], ['name'=>'Precio Bajo']);
        $mid = Category::firstOrCreate(['slug'=>'precio-medio'], ['name'=>'Precio Medio']);
        $high= Category::firstOrCreate(['slug'=>'precio-alto'],  ['name'=>'Precio Alto']);

        $data = [
            ['Runner Pro','RUN-PRO-001',$low->id,28,39.90,[['negro','40','hombre',10],['azul','41','hombre',6]]],
            ['Urban Flex','URB-FLX-002',$mid->id,34,54.90,[['gris','39','mujer',8],['azul','41','hombre',5]]],
            ['Classic Low','CLS-LOW-003',$mid->id,30,49.90,[['blanco','38','mujer',12]]],
            ['Trail Max','TRL-MAX-004',$high->id,52,89.90,[['verde','42','hombre',4]]],
            ['Aero Knit','AER-KNT-005',$low->id,24,36.90,[['rojo','39','unisex',9]]],
            ['Street High','STR-HGH-006',$high->id,60,99.90,[['negro','42','unisex',2]]],
        ];

        foreach($data as [$name,$sku,$cat,$cost,$base,$variants]){
            $p = Product::firstOrCreate(['sku'=>$sku],[
                'category_id'=>$cat,'name'=>$name,'cost'=>$cost,'base_price'=>$base
            ]);
            Media::firstOrCreate(['product_id'=>$p->id,'path'=>"img/{$sku}.jpg"],['is_primary'=>true]);
            foreach($variants as [$color,$talla,$genero,$qty]){
                $v = ProductVariant::firstOrCreate([
                    'product_id'=>$p->id,'color'=>$color,'talla'=>$talla,'genero'=>$genero
                ],['sku_variant'=>$sku.'-'.$color.'-'.$talla.'-'.$genero]);
                VariantStock::firstOrCreate(['variant_id'=>$v->id],['qty'=>$qty]);
            }
        }

        Gestor::firstOrCreate(['token'=>'GESTOR123'],[
            'name'=>'Gestor Demo','phone'=>'+34999999999','uplift_pct_default'=>10
        ]);
    }
}
