<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\{Attribute, AttributeValue, Product};

class ZapateraAttributesSeeder extends Seeder
{
    public function run(): void
    {
        $attrs = [
            ['name'=>'Color',  'slug'=>'color'],
            ['name'=>'Talla',  'slug'=>'talla'],
            ['name'=>'Género', 'slug'=>'genero'],
            // Puedes crear más: Material, Marca, Temporada, etc.
        ];

        foreach ($attrs as $a) {
            Attribute::firstOrCreate(['slug'=>$a['slug']], $a);
        }

        $color = Attribute::where('slug','color')->first();
        $talla = Attribute::where('slug','talla')->first();
        $genero= Attribute::where('slug','genero')->first();

        $negro = AttributeValue::firstOrCreate(['attribute_id'=>$color->id,'slug'=>'negro'], ['value'=>'negro']);
        $azul  = AttributeValue::firstOrCreate(['attribute_id'=>$color->id,'slug'=>'azul'],  ['value'=>'azul']);

        $t41   = AttributeValue::firstOrCreate(['attribute_id'=>$talla->id,'slug'=>'41'], ['value'=>'41']);
        $t38   = AttributeValue::firstOrCreate(['attribute_id'=>$talla->id,'slug'=>'38'], ['value'=>'38']);

        $hombre= AttributeValue::firstOrCreate(['attribute_id'=>$genero->id,'slug'=>'hombre'], ['value'=>'hombre']);
        $mujer = AttributeValue::firstOrCreate(['attribute_id'=>$genero->id,'slug'=>'mujer'],  ['value'=>'mujer']);

        // Ejemplo: etiqueta productos existentes con subcategorías dinámicas
        $p = Product::where('sku','RUN-PRO-001')->first();
        if ($p) {
            $p->attributeValues()->syncWithoutDetaching([$negro->id, $t41->id, $hombre->id]);
        }
    }
}
