<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Services\Settings;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $s = app(Settings::class);

        // Inventory totals
        $s->set('inventory.totals.render_type',     'simple', 'string', 'inventory');
        $s->set('inventory.totals.raw',             false,    'bool',   'inventory');
        $s->set('inventory.totals.only_with_stock', true,     'bool',   'inventory');

        // Ejemplos extra
        $s->set('ui.theme', 'light', 'string', 'ui');
    }
}
