<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixBasePriceSeeder extends Seeder
{
    public function run(): void
    {
        // 1️⃣ ID de monedas
        $CUP_ID = DB::table('currencies')->where('code','CUP')->value('id') ?? 1;
        $USD_ID = DB::table('currencies')->where('code','USD')->value('id') ?? 2;

        // 2️⃣ Tasa de cambio actual USD→CUP (exchange_rate relativo a CUP)
        // Ajusta el campo si se llama distinto
        $usdRate = DB::table('currencies')->where('id',$USD_ID)->value('rate_to_primary') ?? 1;

        // 3️⃣ Selecciona productos “mal” cargados
        $products = DB::table('products')
            ->where('base_price_currency_id',$CUP_ID)
            ->where('base_price','<',100)
            ->get(['id','base_price']);

        $count = 0;

        foreach ($products as $p) {
            $newBasePrice = $p->base_price * $usdRate; // convertir a CUP
            DB::table('products')->where('id',$p->id)->update([
                'base_price' => $newBasePrice,
                'base_price_currency_id' => $USD_ID, // ahora USD
                'updated_at' => now(),
            ]);
            $count++;
        }

        $this->command->info("Actualizados {$count} productos (base_price * {$usdRate}, currency_id={$USD_ID})");
    }
}
