<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixBasePriceHighSeeder extends Seeder
{
    public function run(): void
    {
        // IDs de monedas por code, usando tu tabla currencies
        $CUP_ID = DB::table('currencies')->where('code','CUP')->value('id') ?? 1;

        // Seleccionar productos con base_price > 100 que NO estén marcados como CUP
        $products = DB::table('products')
            ->where('base_price', '>', 100)
            ->where('base_price_currency_id', '<>', $CUP_ID)
            ->get(['id','base_price','base_price_currency_id']);

        $count = 0;

        foreach ($products as $p) {
            // El monto ya está en CUP (porque >100), sólo corregimos la moneda a CUP
            DB::table('products')
                ->where('id', $p->id)
                ->update([
                    'base_price_currency_id' => $CUP_ID,
                    'updated_at' => now(),
                ]);
            $count++;
        }

        $this->command->info("Corregidos {$count} productos: base_price_currency_id => CUP");
    }
}
