<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Currency;

class CurrencySeeder extends Seeder
{
    public function run(): void
    {
        // Principal CUP
        $cup = Currency::updateOrCreate(['code'=>'CUP'],[
            'name'=>'Peso Cubano',
            'symbol'=>'₱',
            'is_primary'=>true,
            'rate_to_primary'=>1,
            'is_active'=>true,
        ]);

        // Secundarias respecto a CUP
        Currency::updateOrCreate(['code'=>'USD'],[
            'name'=>'Dólar Estadounidense',
            'symbol'=>'$',
            'is_primary'=>false,
            'rate_to_primary'=>428,
            'is_active'=>true,
        ]);

        Currency::updateOrCreate(['code'=>'EUR'],[
            'name'=>'Euro',
            'symbol'=>'€',
            'is_primary'=>false,
            'rate_to_primary'=>485,
            'is_active'=>true,
        ]);

        Currency::updateOrCreate(['code'=>'MLC'],[
            'name'=>'Moneda Libremente Convertible',
            'symbol'=>'$',
            'is_primary'=>false,
            'rate_to_primary'=>205,
            'is_active'=>true,
        ]);
    }
}
