<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use App\Models\{Attribute, AttributeValue, Product};

class AttributeSeeder extends Seeder
{
    public function run(): void
    {
        // 1) Definir atributos y sus valores
        $data = [
            'Color' => ['Rojo','Azul','Negro','Blanco','Verde'],
            'Talla' => ['38','39','40','41','42','43','44','45'],
            'Género' => ['Hombre','Mujer','Unisex'],
            'Material' => ['Cuero','Sintético','Tela','Gamuza'],
        ];

        foreach ($data as $attrName => $values) {
            $attribute = Attribute::firstOrCreate(
                ['slug' => Str::slug($attrName)],
                ['name' => $attrName, 'is_filterable' => true]
            );

            foreach ($values as $v) {
                AttributeValue::firstOrCreate(
                    ['attribute_id' => $attribute->id, 'slug' => Str::slug($v)],
                    ['value' => $v]
                );
            }
        }

        // 2) (Opcional) Asignar valores aleatorios a productos existentes
        //    Requiere tabla pivote product_attribute_values (product_id, attribute_value_id)
        //    Descomenta si ya tienes esa tabla.

        $allValues = AttributeValue::with('attribute')->get()->groupBy('attribute_id');
        Product::with('attributeValues')->chunk(50, function ($products) use ($allValues) {
            foreach ($products as $p) {
                foreach ($allValues as $attrId => $values) {
                    // Elige 1 valor para atributos "únicos" (Talla, Género, Material)
                    // y 1-2 para Color como ejemplo
                    $pick = $values->firstWhere('attribute.slug', 'color')
                        ? $values->random(min(2, $values->count()))
                        : $values->random(1);

                    $p->attributeValues()->syncWithoutDetaching($pick->pluck('id')->all());
                }
            }
        });

    }
}
