<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $t) {
            $t->id();
            $t->string('key')->unique();            // p.ej: inventory.totals.render_type
            $t->json('value')->nullable();          // almacenamos siempre JSON
            $t->string('type')->default('string');  // string|bool|int|float|json
            $t->string('group')->nullable();        // p.ej: inventory, ui, billing
            $t->boolean('autoload')->default(true); // para precarga opcional
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('settings'); }
};
