<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('product_media_attribute_values', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('product_media_id');
            $t->unsignedBigInteger('attribute_value_id');
            $t->timestamps();

            $t->unique(['product_media_id','attribute_value_id'], 'media_attr_unique');

            $t->foreign('product_media_id')->references('id')->on('media')->onDelete('cascade');
            $t->foreign('attribute_value_id')->references('id')->on('attribute_values')->onDelete('cascade');
        });

        // (Opcional) cache rápido para pintar chips sin N+1
        Schema::table('media', function (Blueprint $t) {
            if (!Schema::hasColumn('media', 'attributes_cache')) {
                $t->json('attributes_cache')->nullable()->after('is_primary');
            }
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_media_attribute_values');

        Schema::table('media', function (Blueprint $t) {
            if (Schema::hasColumn('media', 'attributes_cache')) {
                $t->dropColumn('attributes_cache');
            }
        });
    }
};
