<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // 1) Si NO existe la columna, la creamos directamente con FK
        if (! Schema::hasColumn('accounting_periods', 'local_id')) {
            Schema::table('accounting_periods', function (Blueprint $t) {
                $t->unsignedBigInteger('local_id')->after('id');
                $t->foreign('local_id')->references('id')->on('locals')->cascadeOnUpdate()->restrictOnDelete();
            });
            return;
        }

        // 2) Si existe, nos aseguramos de que sea NOT NULL y tenga FK
        Schema::table('accounting_periods', function (Blueprint $t) {
            // Si la base necesita doctrine/dbal para modificar columnas:
            // composer require doctrine/dbal
            $t->unsignedBigInteger('local_id')->nullable(false)->change();
        });

        // Añadir la FK si faltaba
        $hasForeign = false;
        // Muchos MySQL no exponen un API fácil para detectar la FK; re-creamos por si acaso:
        Schema::table('accounting_periods', function (Blueprint $t) {
            // Elimina constraint previa si usaste otro nombre (opcional)
            // $t->dropForeign(['local_id']);
            $t->foreign('local_id')->references('id')->on('locals')->cascadeOnUpdate()->restrictOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('accounting_periods', function (Blueprint $t) {
            $t->dropForeign(['local_id']);
            // Si quieres volver a nullable:
            $t->unsignedBigInteger('local_id')->nullable()->change();
        });
    }
};
