<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Nuevas columnas
        Schema::table('locals', function (Blueprint $t) {
            // 1 = products (solo venta), 2 = services (solo servicios), 3 = mixed
            $t->tinyInteger('mode')->default(1)->after('description');
            $t->boolean('dynamic_pricing')->default(false)->after('mode');
            $t->boolean('active')->default(true)->after('dynamic_pricing');
        });

        // Eliminar columnas antiguas si existen
        if (Schema::hasColumn('locals', 'service_manual')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('service_manual'));
        }
        if (Schema::hasColumn('locals', 'dynamic_sale')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('dynamic_sale'));
        }
        if (Schema::hasColumn('locals', 'sale_only')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('sale_only'));
        }
    }

    public function down(): void
    {
        // Volver a crear columnas antiguas (por compatibilidad)…
        Schema::table('locals', function (Blueprint $t) {
            if (! Schema::hasColumn('locals', 'service_manual')) {
                $t->boolean('service_manual')->default(false)->after('description');
            }
            if (! Schema::hasColumn('locals', 'dynamic_sale')) {
                $t->boolean('dynamic_sale')->default(false)->after('service_manual');
            }
            if (! Schema::hasColumn('locals', 'sale_only')) {
                $t->boolean('sale_only')->default(false)->after('dynamic_sale');
            }
        });

        // …y eliminar las nuevas
        if (Schema::hasColumn('locals', 'active')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('active'));
        }
        if (Schema::hasColumn('locals', 'dynamic_pricing')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('dynamic_pricing'));
        }
        if (Schema::hasColumn('locals', 'mode')) {
            Schema::table('locals', fn (Blueprint $t) => $t->dropColumn('mode'));
        }
    }
};
