<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('locals', function (Blueprint $table) {
            $table->id();
            $table->string('alias', 50)->unique();
            $table->string('name', 100);
            $table->string('description', 200)->nullable();
            $table->string('url', 200)->nullable();
            $table->boolean('service_manual')->default(false);
            $table->boolean('dynamic_sale')->default(false);
            $table->boolean('sale_only')->default(false);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('locals');
    }
};
