<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('accounting_periods', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('local_id'); // ámbito único

            $table->date('fecha_inicial');
            $table->date('fecha_final');
            $table->string('descripcion', 200)->nullable();

            $table->boolean('cerrado')->default(false);
            $table->boolean('activo')->default(false);

            $table->timestamps();

            $table->index(['local_id', 'activo', 'cerrado']);
            $table->index(['local_id', 'fecha_inicial', 'fecha_final']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('accounting_periods');
    }
};
