<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        if (!Schema::hasTable('stock_move_batches')) return;

        // Asegurar enum en inglés
        DB::statement("ALTER TABLE `stock_move_batches`
            MODIFY COLUMN `type` ENUM('in','out','adjust') NOT NULL");

        Schema::table('stock_move_batches', function (Blueprint $t) {
            if (!Schema::hasColumn('stock_move_batches','moved_at')) {
                $t->dateTime('moved_at')->nullable()->index()->after('note');
            }
            if (!Schema::hasColumn('stock_move_batches','note')) {
                $t->string('note',255)->nullable()->after('user_id');
            }
            if (!Schema::hasColumn('stock_move_batches','user_id')) {
                $t->unsignedBigInteger('user_id')->nullable()->after('type');
            }
        });
    }

    public function down(): void {
        if (!Schema::hasTable('stock_move_batches')) return;

        // Si quieres revertir enum a español cambia aquí:
        DB::statement("ALTER TABLE `stock_move_batches`
            MODIFY COLUMN `type` ENUM('in','out','adjust') NOT NULL");

        Schema::table('stock_move_batches', function (Blueprint $t) {
            if (Schema::hasColumn('stock_move_batches','moved_at')) $t->dropColumn('moved_at');
            // no eliminamos user_id/note por seguridad
        });
    }
};
