<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // INVENTORY_MOVEMENTS
        if (Schema::hasTable('inventory_movements') && Schema::hasColumn('inventory_movements','type')) {
            // 1) Permite ambos idiomas temporalmente
            DB::statement("ALTER TABLE `inventory_movements`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste','in','out','adjust') NOT NULL");

            // 2) Migra datos existentes a inglés
            DB::table('inventory_movements')->where('type','entrada')->update(['type'=>'in']);
            DB::table('inventory_movements')->where('type','salida')->update(['type'=>'out']);
            DB::table('inventory_movements')->where('type','ajuste')->update(['type'=>'adjust']);

            // 3) Deja solo inglés
            DB::statement("ALTER TABLE `inventory_movements`
                MODIFY COLUMN `type` ENUM('in','out','adjust') NOT NULL");
        }

        // STOCK_MOVE_BATCHES (si usas esta tabla y tiene columna type)
        if (Schema::hasTable('stock_move_batches') && Schema::hasColumn('stock_move_batches','type')) {
            DB::statement("ALTER TABLE `stock_move_batches`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste','in','out','adjust') NOT NULL");

            DB::table('stock_move_batches')->where('type','entrada')->update(['type'=>'in']);
            DB::table('stock_move_batches')->where('type','salida')->update(['type'=>'out']);
            DB::table('stock_move_batches')->where('type','ajuste')->update(['type'=>'adjust']);

            DB::statement("ALTER TABLE `stock_move_batches`
                MODIFY COLUMN `type` ENUM('in','out','adjust') NOT NULL");
        }
    }

    public function down(): void
    {
        // Si quisieras revertir a español (opcional)
        if (Schema::hasTable('inventory_movements') && Schema::hasColumn('inventory_movements','type')) {
            DB::statement("ALTER TABLE `inventory_movements`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste','in','out','adjust') NOT NULL");

            DB::table('inventory_movements')->where('type','in')->update(['type'=>'entrada']);
            DB::table('inventory_movements')->where('type','out')->update(['type'=>'salida']);
            DB::table('inventory_movements')->where('type','adjust')->update(['type'=>'ajuste']);

            DB::statement("ALTER TABLE `inventory_movements`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste') NOT NULL");
        }

        if (Schema::hasTable('stock_move_batches') && Schema::hasColumn('stock_move_batches','type')) {
            DB::statement("ALTER TABLE `stock_move_batches`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste','in','out','adjust') NOT NULL");

            DB::table('stock_move_batches')->where('type','in')->update(['type'=>'entrada']);
            DB::table('stock_move_batches')->where('type','out')->update(['type'=>'salida']);
            DB::table('stock_move_batches')->where('type','adjust')->update(['type'=>'ajuste']);

            DB::statement("ALTER TABLE `stock_move_batches`
                MODIFY COLUMN `type` ENUM('entrada','salida','ajuste') NOT NULL");
        }
    }
};
