<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('inventory_movements') || !Schema::hasColumn('inventory_movements','variant_id')) {
            return;
        }

        // 1) Buscar y eliminar la FOREIGN KEY que involucra variant_id
        $fk = DB::selectOne("
            SELECT CONSTRAINT_NAME
            FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
            WHERE TABLE_SCHEMA = DATABASE()
              AND TABLE_NAME = 'inventory_movements'
              AND COLUMN_NAME = 'variant_id'
              AND REFERENCED_TABLE_NAME IS NOT NULL
            LIMIT 1
        ");

        if ($fk && isset($fk->CONSTRAINT_NAME)) {
            $constraint = $fk->CONSTRAINT_NAME;
            DB::statement("ALTER TABLE `inventory_movements` DROP FOREIGN KEY `{$constraint}`");
        } else {
            // Por si Laravel la nombró con el patrón por defecto
            try { Schema::table('inventory_movements', fn (Blueprint $t) => $t->dropForeign(['variant_id'])); } catch (\Throwable $e) {}
        }

        // 2) Eliminar índice sobre variant_id si queda alguno
        $idx = DB::selectOne("
            SELECT INDEX_NAME
            FROM INFORMATION_SCHEMA.STATISTICS
            WHERE TABLE_SCHEMA = DATABASE()
              AND TABLE_NAME = 'inventory_movements'
              AND COLUMN_NAME = 'variant_id'
            LIMIT 1
        ");
        if ($idx && isset($idx->INDEX_NAME)) {
            $index = $idx->INDEX_NAME;
            DB::statement("ALTER TABLE `inventory_movements` DROP INDEX `{$index}`");
        } else {
            try { Schema::table('inventory_movements', fn (Blueprint $t) => $t->dropIndex(['variant_id'])); } catch (\Throwable $e) {}
        }

        // 3) Finalmente, eliminar la columna
        Schema::table('inventory_movements', function (Blueprint $t) {
            $t->dropColumn('variant_id');
        });
    }

    public function down(): void
    {
        // Si necesitas revertir, volvemos a crear la columna y (opcional) la FK
        if (!Schema::hasTable('inventory_movements') || Schema::hasColumn('inventory_movements','variant_id')) {
            return;
        }

        Schema::table('inventory_movements', function (Blueprint $t) {
            $t->unsignedBigInteger('variant_id')->nullable()->after('batch_id');
            // Si quieres restaurar la FK (ajusta nombre de tabla/columna de variantes):
            // $t->foreign('variant_id')->references('id')->on('product_variants')->cascadeOnDelete();
        });
    }
};
