<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();

        // Cabecera de movimiento (lote)
        if (!Schema::hasTable('stock_move_batches')) {
            Schema::create('stock_move_batches', function (Blueprint $t) {
                $t->id();
                $t->enum('type', ['in', 'out']); // entrada / salida
                $t->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
                $t->string('note')->nullable();
                $t->timestamps();
            });
        }

        // Agregar batch_id a la tabla de movimientos que exista
        if (Schema::hasTable('stock_movements') && !Schema::hasColumn('stock_movements', 'batch_id')) {
            Schema::table('stock_movements', function (Blueprint $t) {
                $t->foreignId('batch_id')->nullable()->after('id')
                  ->constrained('stock_move_batches')->nullOnDelete();
            });
        } elseif (Schema::hasTable('inventory_movements') && !Schema::hasColumn('inventory_movements', 'batch_id')) {
            Schema::table('inventory_movements', function (Blueprint $t) {
                $t->foreignId('batch_id')->nullable()->after('id')
                  ->constrained('stock_move_batches')->nullOnDelete();
            });
        }

        Schema::enableForeignKeyConstraints();
    }

    public function down(): void
    {
        Schema::disableForeignKeyConstraints();

        if (Schema::hasTable('stock_movements') && Schema::hasColumn('stock_movements','batch_id')) {
            Schema::table('stock_movements', function (Blueprint $t) { $t->dropConstrainedForeignId('batch_id'); });
        }
        if (Schema::hasTable('inventory_movements') && Schema::hasColumn('inventory_movements','batch_id')) {
            Schema::table('inventory_movements', function (Blueprint $t) { $t->dropConstrainedForeignId('batch_id'); });
        }

        Schema::dropIfExists('stock_move_batches');

        Schema::enableForeignKeyConstraints();
    }
};
