<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

return new class extends Migration
{
    public function up(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // ==== CREAR ROLES BÁSICOS ====
        $roles = ['admin', 'manager', 'gestor', 'cliente'];

        foreach ($roles as $role) {
            $exists = DB::table('roles')->where('name', $role)->exists();
            if (! $exists) {
                DB::table('roles')->insert([
                    'name'       => $role,
                    'guard_name' => 'web',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }

        // ==== CREAR USUARIO ADMIN ====
        $email = 'admin@tienda.test';
        $admin = DB::table('users')->where('email', $email)->first();

        if (! $admin) {
            $userId = DB::table('users')->insertGetId([
                'name'       => 'Administrador',
                'email'      => $email,
                'password'   => Hash::make('admin'), // contraseña: admin
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        } else {
            $userId = $admin->id;
        }

        // ==== ASIGNAR ROL ADMIN ====
        $adminRoleId = DB::table('roles')->where('name', 'admin')->value('id');
        $alreadyLinked = DB::table('model_has_roles')
            ->where('model_id', $userId)
            ->where('role_id', $adminRoleId)
            ->exists();

        if (! $alreadyLinked) {
            DB::table('model_has_roles')->insert([
                'role_id'    => $adminRoleId,
                'model_type' => 'App\\Models\\User',
                'model_id'   => $userId,
            ]);
        }

        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }

    public function down(): void
    {
        // Eliminar usuario admin y roles (si se desea rollback)
        $email = 'admin@tienda.test';
        $user = DB::table('users')->where('email', $email)->first();
        if ($user) {
            DB::table('model_has_roles')->where('model_id', $user->id)->delete();
            DB::table('users')->where('id', $user->id)->delete();
        }

        DB::table('roles')->whereIn('name', ['admin', 'manager', 'gestor', 'cliente'])->delete();
    }
};
