<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('product_uplifts', function (Blueprint $t) {
      $t->id();
      $t->foreignId('user_id')->constrained()->cascadeOnDelete();   // gestor
      $t->foreignId('product_id')->constrained()->cascadeOnDelete();
      $t->decimal('uplift_percent', 8, 2); // ej. 10.00 (%)
      $t->timestamps();

      $t->unique(['user_id','product_id']);
    });
  }
  public function down(): void {
    Schema::dropIfExists('product_uplifts');
  }
};

