<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('products', function (Blueprint $t) {
            $t->foreignId('cost_currency_id')->nullable()->after('cost')->constrained('currencies')->nullOnDelete();
            $t->foreignId('base_price_currency_id')->nullable()->after('base_price')->constrained('currencies')->nullOnDelete();
        });
    }
    public function down(): void {
        Schema::table('products', function (Blueprint $t) {
            $t->dropConstrainedForeignId('cost_currency_id');
            $t->dropConstrainedForeignId('base_price_currency_id');
        });
    }
};
