<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('currencies', function (Blueprint $t) {
            $t->id();
            $t->string('code', 8)->unique();
            $t->string('name', 64);
            $t->string('symbol', 8)->nullable();
            $t->boolean('is_primary')->default(false);
            $t->decimal('rate_to_primary', 18, 6)->default(1); // 1 MONEDA = X PRINCIPAL
            $t->boolean('is_active')->default(true);
            $t->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('currencies');
    }
};
