<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('inventory_movements', function (Blueprint $table) {
            $table->dateTime('moved_at')->after('qty')->nullable()->index();
        });
        // Si tienes tabla de batches y quieres guardar la misma fecha a nivel lote:
        // Schema::table('inventory_batches', function (Blueprint $table) {
        //     $table->dateTime('moved_at')->nullable()->index();
        // });
    }
    public function down(): void {
        Schema::table('inventory_movements', function (Blueprint $table) {
            $table->dropColumn('moved_at');
        });
        // Schema::table('inventory_batches', function (Blueprint $table) {
        //     $table->dropColumn('moved_at');
        // });
    }
};
