<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('attributes', function (Blueprint $table) {
            $table->id();
            $table->string('name');        // Ej: Color, Talla, Género, Material, Marca...
            $table->string('slug')->unique();
            $table->boolean('is_filterable')->default(true);
            $table->timestamps();
        });

        Schema::create('attribute_values', function (Blueprint $table) {
            $table->id();
            $table->foreignId('attribute_id')->constrained('attributes')->cascadeOnDelete();
            $table->string('value');       // Ej: rojo, 41, hombre
            $table->string('slug');        // rojo, 41, hombre
            $table->unique(['attribute_id','slug']);
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('attribute_values');
        Schema::dropIfExists('attributes');
    }
};
