<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('gestor_price_overrides', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gestor_id')->constrained('gestores')->cascadeOnDelete();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            $table->decimal('price_override', 10, 2)->nullable();
            $table->unique(['gestor_id','product_id']);
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('gestor_price_overrides');
    }
};
