<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            $table->string('color')->nullable();
            $table->string('talla')->nullable();
            $table->string('genero')->nullable();
            $table->string('sku_variant')->nullable()->unique();
            $table->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('product_variants');
    }
};
