<?php
// app/Support/helpers.php

use App\Services\Settings;

if (! function_exists('setting')) {
    /**
     * Lee una opción de configuración persistente.
     *
     * @param string $key     Clave, ej: "inventory.totals.render_type"
     * @param mixed  $default Valor por defecto si no existe la clave
     */
    function setting(string $key, mixed $default = null): mixed
    {
        return app(Settings::class)->get($key, $default);
    }
}

if (! function_exists('setting_set')) {
    /**
     * Guarda/actualiza una opción de configuración.
     *
     * @param string      $key   Clave
     * @param mixed       $value Valor
     * @param string      $type  "string"|"bool"|"int"|"float"|"json"
     * @param string|null $group Grupo lógico (ej: "inventory", "ui")
     * @param bool        $autoload Si debe precargarse en caché global
     */
    function setting_set(
        string $key,
        mixed $value,
        string $type = 'string',
        ?string $group = null,
        bool $autoload = true
    ): void {
        app(Settings::class)->set($key, $value, $type, $group, $autoload);
    }
}
