<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\Attribute;
use App\Policies\AttributePolicy;
use App\Models\Category;
use App\Policies\CategoryPolicy;
use App\Models\Currency;
use App\Policies\CurrencyPolicy;
use App\Models\Product;
use App\Policies\ProductPolicy;
use App\Models\Gestor;
use App\Policies\GestorPolicy;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Attribute::class => AttributePolicy::class,
        Category::class  => CategoryPolicy::class,
        Currency::class  => CurrencyPolicy::class,
        Product::class   => ProductPolicy::class, // opcional
        Gestor::class    => GestorPolicy::class,  // opcional
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        Gate::define('admin', fn(\App\Models\User $u) => $u->role === 'admin');
        Gate::define('gestor', fn(\App\Models\User $u) => $u->role === 'gestor');

        // (Opcional) Admin todo-poderoso
        Gate::before(function ($user, $ability) {
            return $user->role === 'admin' ? true : null;
        });
    }
}
