<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\View;
use App\Services\CurrencyService;
use App\Services\Settings;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
        $this->app->singleton(Settings::class, fn() => new Settings);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //Paginator::useBootstrapFive();
        View::composer(
            ['zapatera.*', 'components.*'], // vistas/paths donde quieras compartir
            function ($view) {
                $service = app(CurrencyService::class);
                $view->with('uiCurrencies', $service->listForDisplay());
            }
        );

    }
}
