<?php

namespace App\Policies;

use App\Models\Product;
use App\Models\User;

class ProductPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function view(User $user, Product $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function update(User $user, Product $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function delete(User $user, Product $model): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Restaurar (solo admin, si usas soft deletes).
     */
    public function restore(User $user, Product $product): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Borrado permanente (solo admin).
     */
    public function forceDelete(User $user, Product $product): bool
    {
        return $user->hasRole('admin');
    }
}
