<?php

namespace App\Policies;

use App\Models\Gestor;
use App\Models\User;

class GestorPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function view(User $user, Gestor $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function update(User $user, Gestor $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function delete(User $user, Gestor $model): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Restaurar (solo admin, si usas soft deletes).
     */
    public function restore(User $user, Gestor $gestor): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Borrado permanente (solo admin).
     */
    public function forceDelete(User $user, Gestor $gestor): bool
    {
        return $user->hasRole('admin');
    }
}
