<?php

namespace App\Policies;

use App\Models\Currency;
use App\Models\User;

class CurrencyPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function view(User $user, Currency $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function update(User $user, Currency $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function delete(User $user, Currency $model): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Restaurar (solo admin, si usas soft deletes).
     */
    public function restore(User $user, Currency $currency): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Borrado permanente (solo admin).
     */
    public function forceDelete(User $user, Currency $currency): bool
    {
        return $user->hasRole('admin');
    }
}
