<?php

namespace App\Policies;

use App\Models\Category;
use App\Models\User;

class CategoryPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function view(User $user, Category $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function update(User $user, Category $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function delete(User $user, Category $model): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Restaurar (solo admin, si usas soft deletes).
     */
    public function restore(User $user, Category $category): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Borrado permanente (solo admin).
     */
    public function forceDelete(User $user, Category $category): bool
    {
        return $user->hasRole('admin');
    }
}
