<?php

namespace App\Policies;

use App\Models\Attribute;
use App\Models\User;

class AttributePolicy
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Attribute::class => AttributePolicy::class,
        // Category::class  => CategoryPolicy::class,
        // Currency::class  => CurrencyPolicy::class,
    ];

    /**
     * Listar/ver el índice.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function view(User $user, Attribute $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function create(User $user): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function update(User $user, Attribute $model): bool
    {
        return $user->hasAnyRole(['admin','manager']);
    }

    public function delete(User $user, Attribute $model): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Restaurar (solo admin, si usas soft deletes).
     */
    public function restore(User $user, Attribute $attribute): bool
    {
        return $user->hasRole('admin');
    }

    /**
     * Borrado permanente (solo admin).
     */
    public function forceDelete(User $user, Attribute $attribute): bool
    {
        return $user->hasRole('admin');
    }
}
