<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    protected $fillable = ['product_id','attribute_values','qty','type','note','user_id'];

    protected $casts = [
        'attribute_values' => 'array',
    ];

    public function product() { return $this->belongsTo(Product::class); }
    public function user() { return $this->belongsTo(User::class); }

    protected function findOrCreateStockRow($productId, array $attributeValues)
    {
        // Normaliza orden de claves para evitar duplicados por orden distinto:
        ksort($attributeValues);
        return \App\Models\Stock::firstOrCreate(
            [
                'product_id' => $productId,
                'attribute_values' => $attributeValues,
            ],
            ['qty' => 0]
        );
    }

}