<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    protected $fillable = [
        'product_id',
        'attribute_values', // JSON con pares { atributo => valor }
        'qty',
    ];

    protected $casts = [
        'attribute_values' => 'array',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Ej: "Color: Rojo / Talla: 41 / Género: Hombre"
    public function getDescripcionAttribute()
    {
        if (empty($this->attribute_values) || !is_array($this->attribute_values)) {
            return '—';
        }
        $parts = [];
        foreach ($this->attribute_values as $k => $v) {
            // Normaliza capitalización
            $parts[] = ucfirst($k).': '.$v;
        }
        return implode(' / ', $parts);
    }
}
